/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.EqualsCheck;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemValueFormatter;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.udf.UDFParameterItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockVMMappingInfo
implements Serializable,
Storable {
    private static final long serialVersionUID = -268560706259095250L;
    private Vector<Param2VMInfo> fMappingVector = new Vector();

    public void addBlockVMMapping(ParameterItem parameter, int offset) {
        Param2VMInfo info = new Param2VMInfo();
        info.paramItem = parameter;
        info.length = parameter instanceof UDFParameterItem ? ((UDFParameterItem)parameter).getRootSourceParameterItem().getLengthInVM() : parameter.getLengthInVM();
        info.address = offset;
        this.fMappingVector.add(info);
    }

    public Vector<Param2VMInfo> getMappingInfo() {
        return this.fMappingVector;
    }

    public void clear() {
        this.fMappingVector.removeAllElements();
    }

    public void executeSynchronizer(Interpreter interpreter) {
        for (Param2VMInfo info : this.fMappingVector) {
            ParameterItem parameterItem = info.paramItem;
            int length = info.length;
            int address = info.address;
            interpreter.writeVM(length, address, ParameterItemValueFormatter.getInstance().getVMValue(parameterItem).intValue());
        }
    }

    public boolean compareTo(BlockVMMappingInfo otherMappingInfo, DifferenceTableModel differences) {
        int i;
        if (otherMappingInfo == null) {
            return false;
        }
        boolean diff = true;
        String vmStr = Language.getString("tool.vmConfigure.mapping", "VM Mapping") + " ";
        String lineStr = Language.getString("dialog.parameter.message.tickerLine", "Line") + " ";
        for (i = 0; i < this.getMappingInfo().size(); ++i) {
            String blockID;
            String lineID;
            Param2VMInfo thisInfo = this.getMappingInfo().get(i);
            if (i > otherMappingInfo.getMappingInfo().size() - 1) {
                lineID = vmStr + lineStr + String.valueOf(i + 1);
                blockID = thisInfo.paramItem.getParameter().getBlock().getNumberString();
                String notFoundStr = Language.getString("compare.notFound", "Not found");
                differences.add(lineID, blockID + " - " + thisInfo.paramItem.getLocalisedName(), notFoundStr);
                diff = false;
                break;
            }
            if (!thisInfo.isEqual(otherMappingInfo.getMappingInfo().get(i))) {
                lineID = vmStr + lineStr + String.valueOf(i + 1);
                blockID = thisInfo.paramItem.getParameter().getBlock().getNumberString();
                ParameterItem otherItem = otherMappingInfo.getMappingInfo().get((int)i).paramItem;
                String otherBlockID = otherItem.getParameter().getBlock().getNumberString();
                differences.add(lineID, blockID + " - " + thisInfo.paramItem.getLocalisedName(), otherBlockID + " - " + otherItem.getLocalisedName());
                diff = false;
                break;
            }
            if (thisInfo.address == otherMappingInfo.getMappingInfo().get((int)i).address) continue;
            lineID = vmStr + lineStr + String.valueOf(i + 1) + " - " + Language.getString("tool.vmConfigure.address", "Address");
            differences.add(lineID, String.valueOf(thisInfo.address), String.valueOf(otherMappingInfo.getMappingInfo().get((int)i).address));
            diff = false;
            break;
        }
        if (diff && this.getMappingInfo().size() < otherMappingInfo.getMappingInfo().size()) {
            String lineID = vmStr + lineStr + String.valueOf(i + 1);
            String notFoundStr = Language.getString("compare.notFound", "Not found");
            ParameterItem otherItem = otherMappingInfo.getMappingInfo().get((int)i).paramItem;
            String blockID = otherItem.getParameter().getBlock().getNumberString();
            differences.add(lineID, notFoundStr, blockID + " - " + otherItem.getLocalisedName());
            diff = false;
        }
        return diff;
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        int cnt = dr.readInt();
        if (cnt > 0) {
            this.fMappingVector = new Vector(cnt);
            for (int i = 0; i < cnt; ++i) {
                this.fMappingVector.add((Param2VMInfo)dr.readStorable());
            }
        }
    }

    @Override
    public void write(StorableOutput dw) {
        if (this.fMappingVector != null) {
            dw.writeInt(this.fMappingVector.size());
            for (Param2VMInfo info : this.fMappingVector) {
                dw.writeStorable(info);
            }
        } else {
            dw.writeInt(0);
        }
    }

    public BlockVMMappingInfo deepCopy() {
        BlockVMMappingInfo clonedInfo = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(200);
            StorableOutput so = new StorableOutput(outputStream);
            so.writeStorable(this);
            so.close();
            byte[] clipboard = outputStream.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(clipboard);
            StorableInput si = new StorableInput(inputStream);
            clonedInfo = (BlockVMMappingInfo)si.readStorable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clonedInfo;
    }

    public static class Param2VMInfo
    implements Serializable,
    EqualsCheck,
    Storable {
        private static final long serialVersionUID = 1660822713544470485L;
        public int address;
        public ParameterItem paramItem;
        public int length;

        public boolean isEqual(Object element) {
            if (!(element instanceof Param2VMInfo)) {
                return false;
            }
            if (!this.paramItem.isEqual(((Param2VMInfo)element).paramItem)) {
                return false;
            }
            return this.paramItem.getParameter().getBlock().isEqual(((Param2VMInfo)element).paramItem.getParameter().getBlock());
        }

        public void read(StorableInput dr) throws IOException {
            this.address = dr.readInt();
            this.paramItem = (ParameterItem)dr.readStorable();
            this.length = dr.readInt();
        }

        public void write(StorableOutput dw) {
            dw.writeInt(this.address);
            dw.writeStorable(this.paramItem);
            dw.writeInt(this.length);
        }
    }
}

